'-------------------------------------------------------------------------------
' RW3XA for RW3AZ PLL@ADF4106 Ver.N2 (2nd Freq switch) BASCOM 2.0.7.1 ATTINY13*
' 08 Aug 2017            F1=4965MHz   F2=5010MHz
'-------------------------------------------------------------------------------
Rem  FUSES: CLKDIV8 = 0 (programmed), CKSEL= 10 (9.6Mc internal RC clock)
'
$regfile = "ATtiny13.dat"
$crystal = 9600000                                          '9600000 default Internal RC Clock
                                           '    Proteus   1200000
$hwstack = 8
$swstack = 8
$framesize = 8

'Declare Sub Main
Declare Sub Init_adf4106
Declare Sub Sendreg
Declare Sub Waitf1
Declare Sub Waitf2

Dim Tmp As Byte
Dim Switch As Byte
Dim K As Byte
Dim J As Byte

Config Portb = Output                                       '
Config Portb.3 = Input                                      'F1/F2 selector F1=1, F2=0

Le Alias Portb.2                                            'Tiny pin 7 - LE ADF4106
Dat Alias Portb.1                                           'Tiny pin 6 - DATA ADF4106
Clk Alias Portb.0                                           'Tiny pin 5 - CLK ADF4106
Freqsel Alias Portb.3                                       'Freq selector pin ("1"=F1, "2"=F2)

DenounceTime Alias 15                                       '15ms debounce time

'-------------------------------------------------------------------------------
Main:
   Set Le
   Set Freqsel
   Reset Dat
   Reset Clk

   Set Dat
   Waitms 100
   Reset Dat

   If Pinb.3 = 1 Then Goto F1                               '  .  
   If Pinb.3 = 0 Then Goto F2                               '  .  

Modecheck:
   Waitms 1
   If Pinb.3 = 0 And Switch = 0 Then Goto Modecheck         '  F2,   
   If Pinb.3 = 1 And Switch = 1 Then Goto Modecheck         ' c F1,   
   If Pinb.3 = 0 And Switch = 1 Then Goto Waitf2            '  F1,     PB3  0 (F2)
   If Pinb.3 = 1 And Switch = 0 Then Goto Waitf1            '  F2,     PB3  1 (F1)
Goto Modecheck


Waitf1:                                                     '  15ms "1"  PB3  F1,  
   Tmp = 0
   For K = 1 To DenounceTime
      If Pinb.3 = 1 Then Tmp = Tmp + 1
      Waitms 1
   Next
   If Tmp = DenounceTime Then Goto F1
Goto Modecheck

Waitf2:                                                     '  15ms "0"  PB3   F2,  
   Tmp = 0
   For K = 1 To DenounceTime
      If Pinb.3 = 0 Then Tmp = Tmp + 1
      Waitms 1
   Next
   If Tmp = DenounceTime Then Goto F2
Goto Modecheck

F1:
   Restore Reg_table_f1
   Gosub Init_adf4106
   Switch = 1
Goto Modecheck

F2:
   Restore Reg_table_f2
   Gosub Init_adf4106
   Switch = 0
Goto Modecheck


'------------------------------------------------------------------------------
'Init ADF4106 with constant values (4 registers by 3 bytes)
Sub Init_adf4106:

 For K = 1 To 4                                             '4 registers
   Reset Le
   Waitms 1
      For J = 1 To 3                                        '3 bytes
         Read Tmp
         Shiftout Dat , Clk , Tmp , 1
      Next
   Set Le
   Reset Clk
   Reset Dat
 Next

 Waitms 1
Return
End Sub

'-------------------------------------------------------------------------------
'     PLL ADFxxxx

$data
Data "..."
Data "_F1(4965):_PB3=1_MSB_to_LSB_4x_3-bytes_registersIIIFFFNNNRRRR...___from_adr_2a0:"
Reg_table_f1:                                               '
Data &H80 , &H00 , &H13                                     '3 INIT LATCH
Data &H80 , &H00 , &H12                                     '2 FUNCTION LATCH
Data &H00 , &H1F , &H05                                     '1 N COUNTER LATCH
Data &H00 , &H00 , &H08                                     '0 R COUNTER LATCH

Data "#"                                                    '

Data "_F2(5010):_PB3=0_MSB_to_LSB_4x_3-bytes_registersIIIFFFNNNRRRR...___from_adr_300:"
Reg_table_f2:                                               '
Data &H80 , &H00 , &H13                                     '3 INIT LATCH
Data &H80 , &H00 , &H12                                     '2 FUNCTION LATCH
Data &H00 , &H1F , &H29                                     '1 N COUNTER LATCH
Data &H00 , &H00 , &H08                                     '0 R COUNTER LATCH

Data "#"                                                    '
Data "ADF4x_Loader_v2__rw3xa@mail.ru__"
